	% Example 6.9	% bonding box
	clear al
	close all
	clc
	
	N = 15; wcT = 0.2*pi; wsT = 0.5*pi; dc = 0.05; ds = 0.01;
	
	[vlb,vub,h0,hlb,hub] = BOUNDING_BOX_FIR(N,[wcT wsT],[dc ds],[],[])
	% subplot('position', [0.1 0.4 0.88 0.5]); 
	stem(h0,'k','filled'), hold on	
	
	stem(hlb,'r'), hold on
	stem(hub), hold off, grid on
	ylabel('{\ith}({\itnT})','FontName', 'times','FontSize', 16);
	xlabel('{\itn}','FontName', 'times','FontSize', 16);
	
	ulp = 2^-6;
	for n=1:8
		%		n
		yl = floor(hlb(n)/ulp)+1;
		yu = floor(hub(n)/ulp);
		yu-yl
	end

